context('UserSelect', () => {
   const $SaveButton = '[data-e2e="SaveFooter:save"]'

   const $suggestField = '.yc-text-input__control[placeholder="Login or group"]'
   const $suggestItem = '.yc-suggest__item > div'

   const testString = 'svc_tttt_development'


   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /suggest/, {
         fixture: 'suggestUserSelect'
      }).as('getSuggestions')

      cy.visit('/automation_plots/new');

      cy.mockSwitcher()

      cy.get($suggestField).eq(0).clear()
      cy.get($suggestField).eq(0).type(testString)
      cy.get($suggestField).eq(0).should((el) => {
         expect(el.val()).include(testString)
      })

      cy.wait('@getSuggestions')
   })

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist')
   })

   it('Check request', () => {
      cy.intercept('POST', 'v1/automation-plot/', (req) => {
         if (req.body) {
            expect(req.body.owners).include(`@${testString}`)
         }
      }).as('updateProject')

      cy.get($suggestItem).contains(testString).click()

      // заполняем форму

      cy.get('input[name="name"]').type('test')

      cy.get($SaveButton).click()

      cy.wait('@updateProject')
   });
});
