context('Create new Automation Plot', () => {
   const testStr = 'test';

   const $inputName = 'input[placeholder="Enter plot name"]';
   const $inputFolderId = 'input[name="yc_iam_folder_id"]';
   const $checkboxProfile = 'input[name="profile"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('New AP with profile check', () => {
      // request
      cy.intercept('v1/automation-plot', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'checks': [
                  {
                     'enabled': true,
                     'name': testStr,
                     'reboot': false,
                     'redeploy': false,
                     'profile': true,
                     'wait': false,
                     'report_failure': true,
                  },
               ],
               'id': testStr,
               'name': testStr,
               yc_iam_folder_id: testStr,
            });
         }
      }).as('CreatePlot');

      cy.visit('/automation_plots/new', {
         onBeforeLoad: function (window) {
            window.localStorage.setItem('settings.api.preset', JSON.stringify('mock'));
            window.localStorage.setItem('settings.installation.preset', JSON.stringify('external'));
         },
      });

      cy.get($inputName).eq(0).type(testStr);

      cy.get($inputName).eq(1).type(testStr);
      cy.get($inputFolderId).type(testStr);
      cy.get($checkboxProfile).check();
      cy.get('.yc-button__text').contains('Add').click({ force: true });
      cy.get('.yc-button__text').contains('Create plot').click({ force: true });

      cy.wait('@CreatePlot');
   });
});
