context('Create new Maintenance Plot', () => {
   enum ScenarioTypeEnum {
      ITDCMaintenance = 0,
      NOCHard = 1,
   }

   let type = ScenarioTypeEnum.ITDCMaintenance;

   const testStr = 'test';
   const testNum = 123;

   // meta info
   const $inputName = 'input[name="meta_info.name"]';
   const $inputAbcService = 'input[placeholder="ABC service slug"]';

   // commom settings
   const $inputGlobalLim =
      'input[name="common_settings.common_scenario_settings.dont_allow_start_scenario_if_total_number_of_active_hosts_more_than"]';
   const $inputAutoApprove = 'input[name="common_settings.common_scenario_settings.total_number_of_active_hosts"]';
   const $inputLogins = 'input[placeholder="Enter login"]';
   const $inputAbcRolesCodes = 'input[name="common_settings.maintenance_approvers.abc_roles_codes"]';
   const $inputAbcRoleScopeSlug = 'input[name="common_settings.maintenance_approvers.abc_role_scope_slugs"]';
   const $inputAbcDuteScheduleSlug = 'input[name="common_settings.maintenance_approvers.abc_duty_schedule_slugs"]';

   // scenario settings
   const $itdcTypeSelect = '[data-e2e="ITDCMaintenanceTab"]';
   const $nocHardTypeSelect = '[data-e2e="NOCHardTab"]';
   const $enableDisableToggler = '.yc-radio-button__option-text';

   const $inputApprovalSla = scenarioType => `input[name="scenarios_settings[${scenarioType}].settings.approval_sla"]`;
   const $inputUseYpSla = scenarioType => `input[name="scenarios_settings[${scenarioType}].settings.use_yp_sla"]`;
   const $inputStartReguestingCms = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.request_cms_x_seconds_before_maintenance_start_time"]`;
   const $inputIgnore = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.ignore_cms_on_host_operations"]`;
   const $inputManualApproval = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.enable_manual_approval_after_hosts_power_off"]`;
   const $inputStartPoweroff = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.start_power_off_x_seconds_before_maintenance_start_time"]`;
   const $inputCallBeforehand = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds"]`;
   const $inputCallWhenStart = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time"]`;
   const $inputRedeploy = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.enable_redeploy_after_change_of_mac_address"]`;

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check request', () => {
      // request
      cy.intercept('v1/maintenance-plots', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'id': testStr,
               'meta_info': { 'abc_service_slug': testStr, 'name': testStr },
               'common_settings': {
                  'maintenance_approvers': {
                     'logins': [testStr, String(testNum)],
                     'abc_roles_codes': [testStr, String(testNum)],
                     'abc_role_scope_slugs': [testStr, String(testNum)],
                     'abc_duty_schedule_slugs': [testStr, String(testNum)],
                  },
                  'common_scenario_settings': {
                     'dont_allow_start_scenario_if_total_number_of_active_hosts_more_than': testNum,
                     'total_number_of_active_hosts': testNum,
                  },
               },
               'scenarios_settings': [
                  {
                     'scenario_type': 'itdc-maintenance',
                     'settings': {
                        'approval_sla': testNum,
                        'use_yp_sla': true,
                        'request_cms_x_seconds_before_maintenance_start_time': null,
                        'ignore_cms_on_host_operations': true,
                        'start_power_off_x_seconds_before_maintenance_start_time': testNum,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds': testNum,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time': true,
                        'enable_redeploy_after_change_of_mac_address': true,
                        "enable_manual_approval_after_hosts_power_off": false,
                     },
                  },
                  {
                     'scenario_type': 'noc-hard',
                     'settings': {
                        'approval_sla': testNum,
                        'request_cms_x_seconds_before_maintenance_start_time': testNum,
                        'ignore_cms_on_host_operations': true,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds': testNum,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time': true,
                        'enable_redeploy_after_change_of_mac_address': true,
                        'enable_manual_approval_after_hosts_power_off': true,
                     },
                  },
               ],
            });
         }
      }).as('CreatePlot');

      cy.visit('/maintenance_plots/new');

      cy.mockSwitcher();

      // meta info
      cy.get($inputName).type(testStr);
      cy.get($inputAbcService).type(testStr);
      cy.get($inputGlobalLim).type(testNum);
      cy.get($inputAutoApprove).type(testNum);

      // commom settings
      cy.get($inputLogins).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcRolesCodes).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcRoleScopeSlug).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcDuteScheduleSlug).type(testStr).type('{enter}').type(testNum).type('{enter}');

      // scenario settings

      // enable itdc
      cy.get($itdcTypeSelect).click({ force: true });
      cy.get($enableDisableToggler).contains('Enable').click({ force: true });

      type = ScenarioTypeEnum.ITDCMaintenance;

      cy.get($inputApprovalSla(type)).type(testNum);
      cy.get($inputUseYpSla(type)).check();
      cy.get($inputIgnore(type)).check();
      cy.get($inputStartPoweroff(type)).type(testNum);
      cy.get($inputCallBeforehand(type)).type(testNum);
      cy.get($inputCallWhenStart(type)).check();
      cy.get($inputRedeploy(type)).check();

      // enable noc
      cy.get($nocHardTypeSelect).click({ force: true });
      cy.get($enableDisableToggler).contains('Enable').click({ force: true });

      type = ScenarioTypeEnum.NOCHard;

      cy.get($inputApprovalSla(type)).type(testNum);
      cy.get($inputStartReguestingCms(type)).type(testNum);
      cy.get($inputIgnore(type)).check();
      cy.get($inputManualApproval(type)).check();
      cy.get($inputCallBeforehand(type)).type(testNum);
      cy.get($inputCallWhenStart(type)).check();
      cy.get($inputRedeploy(type)).check();

      cy.get('.yc-button__text').contains('Create Plot').click({ force: true });

      cy.wait(500);
      cy.wait('@CreatePlot');
   });
});
