context('Delete Maintenance Plot', () => {
   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check request', () => {
      // response
      cy.intercept('GET', /\/v1\/maintenance-plots\?([\w\d.-]+?)/, {
         fixture: 'maintenance-plots',
      }).as('maintenance-plots');

      // request
      cy.intercept('v1/maintenance-plots/maintenance-plot-mock', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ 'reason': '' });
         }
      }).as('DeletePlot');

      cy.visit('/maintenance_plots');

      cy.wait(500);
      cy.wait('@maintenance-plots');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Remove').eq(0).click({ force: true });
      cy.get('.yc-button__text').contains('Confirm').click({ force: true });

      cy.wait(500);
      cy.wait('@DeletePlot');
   });
});
