context('Update Maintenance Plot', () => {
   enum ScenarioTypeEnum {
      NOCHard = 0,
      ITDCMaintenance = 1,
   }

   let type = ScenarioTypeEnum.ITDCMaintenance;

   const testStr = 'test';
   const testNum = 123;

   // meta info
   const $inputName = 'input[name="meta_info.name"]';
   const $inputAbcService = 'input[placeholder="ABC service slug"]';

   // commom settings
   const $inputGlobalLim =
      'input[name="common_settings.common_scenario_settings.dont_allow_start_scenario_if_total_number_of_active_hosts_more_than"]';
   const $inputAutoApprove = 'input[name="common_settings.common_scenario_settings.total_number_of_active_hosts"]';
   const $inputLogins = 'input[placeholder="Enter login"]';
   const $inputAbcRolesCodes = 'input[name="common_settings.maintenance_approvers.abc_roles_codes"]';
   const $inputAbcRoleScopeSlug = 'input[name="common_settings.maintenance_approvers.abc_role_scope_slugs"]';
   const $inputAbcDuteScheduleSlug = 'input[name="common_settings.maintenance_approvers.abc_duty_schedule_slugs"]';

   // scenario settings
   const $itdcTypeSelect = '[data-e2e="ITDCMaintenanceTab"]';
   const $nocHardTypeSelect = '[data-e2e="NOCHardTab"]';
   const $enableDisableToggler = '.yc-radio-button__option-text';

   const $inputApprovalSla = scenarioType => `input[name="scenarios_settings[${scenarioType}].settings.approval_sla"]`;
   const $inputUseYpSla = scenarioType => `input[name="scenarios_settings[${scenarioType}].settings.use_yp_sla"]`;
   const $inputIgnore = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.ignore_cms_on_host_operations"]`;
   const $inputStartPoweroff = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.start_power_off_x_seconds_before_maintenance_start_time"]`;
   const $inputCallBeforehand = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds"]`;
   const $inputCallWhenStart = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time"]`;
   const $inputRedeploy = scenarioType =>
      `input[name="scenarios_settings[${scenarioType}].settings.enable_redeploy_after_change_of_mac_address"]`;

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check request', () => {
      // response
      cy.intercept('GET', /\/v1\/maintenance-plots\/maintenance-plot-mock\?([\w\d.-]+?)/, {
         fixture: 'maintenance-plot-item',
      }).as('maintenance-plot-item');

      // request
      cy.intercept('v1/maintenance-plots/maintenance-plot-mock/meta_info', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'abc_service_slug': 'test-modify-meta-info5test',
               'name': 'Maintenance plot mock with modified meta info5test',
               'reason': '',
            });
         }
      }).as('UpdatePlot-MetaInfo');

      cy.intercept('v1/maintenance-plots/maintenance-plot-mock/common_settings', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'maintenance_approvers': {
                  'abc_role_scope_slugs': ['aaa', 'bbb', testStr, String(testNum)],
                  'abc_roles_codes': ['aa', 'bb', testStr, String(testNum)],
                  'logins': ['a', 'b', testStr, String(testNum)],
                  'abc_duty_schedule_slugs': [testStr, String(testNum)],
               },
               'common_scenario_settings': {
                  'dont_allow_start_scenario_if_total_number_of_active_hosts_more_than': testNum,
                  'total_number_of_active_hosts': testNum,
               },
               'reason': '',
            });
         }
      }).as('UpdatePlot-CommonSettigs');

      cy.intercept('v1/maintenance-plots/maintenance-plot-mock/scenarios_settings', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'scenarios_settings': [
                  {
                     'scenario_type': 'itdc-maintenance',
                     'settings': {
                        'enable_redeploy_after_change_of_mac_address': true,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time': true,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_hours': null,
                        'get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds': testNum,
                        'ignore_cms_on_host_operations': true,
                        'request_cms_x_hours_before_maintenance_start_time': null,
                        'request_cms_x_seconds_before_maintenance_start_time': null,
                        'start_power_off_x_hours_before_maintenance_start_time': null,
                        'start_power_off_x_seconds_before_maintenance_start_time': testNum,
                        'use_yp_sla': true,
                        'approval_sla': testNum,
                        'enable_manual_approval_after_hosts_power_off': false,
                     },
                  },
               ],
               'reason': '',
            });
         }
      }).as('UpdatePlot-ScenarioSettings');

      cy.visit('/maintenance_plots/maintenance-plot-mock');

      cy.wait(500);
      cy.wait('@maintenance-plot-item');

      cy.mockSwitcher();

      // meta info
      cy.get($inputName).type(testStr);
      cy.get($inputAbcService).type(testStr);
      cy.get($inputGlobalLim).type(testNum);
      cy.get($inputAutoApprove).type(testNum);

      // commom settings
      cy.get($inputLogins).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcRolesCodes).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcRoleScopeSlug).type(testStr).type('{enter}').type(testNum).type('{enter}');
      cy.get($inputAbcDuteScheduleSlug).type(testStr).type('{enter}').type(testNum).type('{enter}');

      // scenario settings

      // enable itdc
      cy.get($itdcTypeSelect).click({ force: true });
      cy.get($enableDisableToggler).contains('Enable').click({ force: true });

      type = ScenarioTypeEnum.ITDCMaintenance;

      cy.get($inputApprovalSla(type)).type(testNum);
      cy.get($inputUseYpSla(type)).check();
      cy.get($inputIgnore(type)).check();
      cy.get($inputStartPoweroff(type)).type(testNum);
      cy.get($inputCallBeforehand(type)).type(testNum);
      cy.get($inputCallWhenStart(type)).check();
      cy.get($inputRedeploy(type)).check();

      // disable noc
      cy.get($nocHardTypeSelect).click({ force: true });
      cy.get($enableDisableToggler).contains('Disable').click({ force: true });

      cy.get('.yc-button__text').contains('Save changes').click({ force: true });
      cy.get('.button2__text').contains('Ok').click({ force: true });

      cy.wait(500);
      cy.wait('@UpdatePlot-MetaInfo');

      cy.wait(500);
      cy.wait('@UpdatePlot-CommonSettigs');

      cy.wait(500);
      cy.wait('@UpdatePlot-ScenarioSettings');
   });
});
