const $EditProjectButton = '[data-e2e="EditProjectButton"]';
const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
const $SubmitButton = 'button[type="submit"]';

const $cAuthSelect = 'div[name="cauth"] .yc-select-control';

// flow_type
const $flowTypeClassic = '.yc-select-item__title[title="Classic"]';
const $flowTypeBackendSource = '.yc-select-item__title[title="Backend source"]';

// key_sources
const $keySourcesStaff = '.yc-select-item__title[title="Staff"]';
const $keySourcesSecure = '.yc-select-item__title[title="Secure"]';

// trusted_sources
const $trustedSourcesBot = '.yc-select-item__title[title="Bot"]';
const $trustedSourcesCms = '.yc-select-item__title[title="Cms"]';
const $trustedSourcesHd = '.yc-select-item__title[title="Hd"]';

const $insecureUrlInput = 'input[name="insecure_ca_list_url"]';
const $krlUrlInput = 'input[name="krl_url"]';
const $secureUrlInput = 'input[name="secure_ca_list_url"]';
const $sudoUrlInput = 'input[name="sudo_ca_list_url"]';

const testUrl = 'https://localhost.yandex-team.ru:3000/project/test';

context('CAuthForm:flow_type=classic', () => {
   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');
   });

   it('Check request', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               cauth_flow_type: 'classic',
               cauth_insecure_ca_list_url: testUrl,
               cauth_key_sources: ['staff', 'secure'],
               cauth_krl_url: testUrl,
               cauth_trusted_sources: [],
               reason: '',
            });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.mockSwitcher();

      cy.wait('@sandbox-mtn');

      cy.get($EditProjectButton).click();

      cy.get($cAuthSelect).eq(0).click(); // flow_type
      cy.get($flowTypeClassic).click();

      cy.get($cAuthSelect).eq(1).click(); // key_sources
      cy.get($keySourcesStaff).click();
      cy.get($keySourcesSecure).click();

      cy.get($insecureUrlInput).type(testUrl);
      cy.get($krlUrlInput).type(testUrl);

      // заполняем required поля формы
      cy.get($SaveProjectButton).click();
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});

context('CAuthForm:flow_type=backend_source', () => {
   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');
   });

   it('Check request', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn', req => {
         if (req.body) {
            console.log(req.body);
            expect(req.body).to.deep.equal({
               cauth_flow_type: 'backend_sources',
               cauth_key_sources: ['secure'],
               cauth_secure_ca_list_url: testUrl,
               cauth_sudo_ca_list_url: testUrl,
               cauth_trusted_sources: ['bot', 'cms', 'hd'],
               reason: '',
            });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.mockSwitcher();

      cy.wait('@sandbox-mtn');

      cy.get($EditProjectButton).click();

      cy.get($cAuthSelect).eq(0).click(); // flow_type
      cy.get($flowTypeBackendSource).click();

      cy.get($cAuthSelect).eq(1).click(); // key_sources
      cy.get($keySourcesSecure).click();

      cy.get($sudoUrlInput).type(testUrl);
      cy.get($secureUrlInput).type(testUrl);

      cy.get($cAuthSelect).eq(2).click(); // trusted_sources
      cy.get($trustedSourcesBot).click();
      cy.get($trustedSourcesCms).click();
      cy.get($trustedSourcesHd).click();

      // заполняем required поля формы
      cy.get($SaveProjectButton).click();
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
