context('CmsForm', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const $addButton = 'div[data-e2e="cms"] .yc-button_view_outlined';
   const $removeButton = 'div[data-e2e="cms"] .yc-button_view_flat';

   const testNumber = '123';
   const tesUrl = 'https://123.com';

   const $inputAppID = 'input[name="tvm_app_id"]';
   const $inputApiUrl = 'input[name="url"]';
   const $tumblerTemporaryUnrechable = 'input[name="temporary_unreachable_enabled"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Edit Project: add and remove cms', () => {
      // response
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      // request
      cy.intercept('v1/projects/sandbox-mtn/cms_settings', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               cms_settings: [
                  {
                     api_version: 'v1.4',
                     tvm_app_id: 123,
                     url: 'https://123.com',
                     temporary_unreachable_enabled: true
                  },
                  {
                     max_busy_hosts: 10,
                     url: 'default',
                  },
               ],
               reason: '',
            });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($addButton).click();
      cy.get($addButton).click();
      cy.get($removeButton).eq(0).click({ force: true });

      cy.get('.yc-radio-button__option-text').contains('Custom').eq(0).click({ force: true });
      cy.get($inputAppID).type(testNumber);
      cy.get($inputApiUrl).type(tesUrl);
      cy.get($tumblerTemporaryUnrechable).check({ force: true });

      cy.get($SaveProjectButton).click();
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });

   it('Edit Project: add and remove cms:Without TVM APP ID', () => {
      // response
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      // request
      cy.intercept('v1/projects/sandbox-mtn/cms_settings', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               cms_settings: [
                  {
                     api_version: 'v1.4',
                     url: 'https://123.com',
                     temporary_unreachable_enabled: true
                  },
                  {
                     max_busy_hosts: 10,
                     url: 'default',
                  },
               ],
               reason: '',
            });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($addButton).click();
      cy.get($addButton).click();
      cy.get($removeButton).eq(0).click({ force: true });

      cy.get('.yc-radio-button__option-text').contains('Custom').eq(0).click({ force: true });
      cy.get($inputApiUrl).type(tesUrl);
      cy.get($tumblerTemporaryUnrechable).check({ force: true });

      cy.get($SaveProjectButton).click();
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
