context('Create Full Project', () => {
   // button
   const $CreateButton = 'button[data-e2e="SaveProjectButton"]';

   // fields
   const $TypeSelect = 'div[name="basic"] .yc-select-control';
   const $TypeVm = '.yc-select-item__title[title="vm"]';
   const $ProjectNameField = 'input[name="name"]';
   const $FolderID = 'input[name="yc_iam_folder_id"]';
   const $AbcServiceField = 'input[placeholder="ABC service slug"]';

   // value
   const testString = 'rtc';
   const testSuggestString = 'sandbox-ci';

   const $suggestItem = '.yc-suggest__item > div';

   before(() => {
      cy.clearCookies();

      cy.intercept('GET', /\/external_api\/abc\/services?([\w\d.-]+?)/, {
         fixture: 'suggestAbcProject',
      }).as('getSuggestions');

      cy.intercept('GET', /\/v1\/bot-projects$/, {
         fixture: 'bot-projects',
      }).as('bot-projects');

      cy.loginRobot();
      cy.baseIntercept();
   });

   it('BasicForm', () => {
      cy.intercept('POST', 'v1/projects', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               bot_project_id: 100008645,
               cauth_flow_type: 'classic',
               cauth_insecure_ca_list_url: '',
               cauth_key_sources: [],
               cauth_krl_url: '',
               cauth_secure_ca_list_url: '',
               cauth_sudo_ca_list_url: '',
               cauth_trusted_sources: [],
               certificate_deploy: false,
               cms_settings: [{ max_busy_hosts: 10, url: 'default' }],
               default_host_restrictions: [],
               enable_dns_automation: false,
               enable_healing_automation: false,
               id: testString,
               name: testString,
               notifications: { recipients: { audit: [], bot: [], critical: [], error: [], info: [], warning: [] } },
               provisioner: 'lui',
               reason: '',
               reboot_via_ssh: false,
               tags: [],
               use_fastbone: true,
               yc_iam_folder_id: testString,
               type: 'vm',
            });
         }
      }).as('createProject');

      cy.visit('/project/new', {
         onBeforeLoad: function (window) {
            window.localStorage.setItem('settings.api.preset', JSON.stringify('mock'));
            window.localStorage.setItem('settings.installation.preset', JSON.stringify('external'));
         },
      });

      cy.get($TypeSelect).eq(0).click(); // flow_type
      cy.get($TypeVm).click();

      cy.get($ProjectNameField).type(testString);
      cy.get($FolderID).type(testString);

      cy.get($AbcServiceField).type(testSuggestString);
      cy.wait('@bot-projects');
      cy.get($suggestItem).contains(testSuggestString).click();

      cy.get($CreateButton).click();
      cy.get('.button2__text').contains('Ok').click({ force: true });

      cy.wait('@createProject');
   });
});
