context('DNSForm', () => {
   const $dnsDomainInput = 'input[name="dns_domain"]';
   const $dnsZoneIDInput = 'input[name="yc_dns_zone_id"]';

   const dnsDomain = 'wall-e.cloud.yandex.net';
   const dnsZoneId = 'dns0j2vr7lth0a6nq4tu';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      cy.intercept('GET', /hbf-projects$/, {
         fixture: 'suggestHbfProject',
      }).as('getSuggestHbfProject');
   });

   it('Check request', () => {
      cy.intercept('POST', '/v1/projects/sandbox-mtn/dns_domain', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'dns_domain': dnsDomain,
               'yc_dns_zone_id': dnsZoneId,
               'reason': '',
            });
         }
      }).as('updateDns');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      // Edit Btn
      cy.get('[data-e2e="automations"] .yc-button__text').contains('Edit').click({ force: true });

      cy.get($dnsDomainInput).clear();
      cy.get($dnsDomainInput).type(dnsDomain);
      cy.get($dnsZoneIDInput).type(dnsZoneId);

      // Update Btn
      cy.get('.button2__text').contains('Update').click({ force: true });

      cy.wait('@updateDns');
   });
});
