context('DisabledChecksForm', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const $sshToggler = 'input[name="ssh"]';
   const $netmonToggler = 'input[name="netmon"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');
   });

   it('Check request with manually_disabled_checks', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ manually_disabled_checks: ['ssh', 'netmon'], reason: '' });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($sshToggler).check({ force: true });
      cy.get($netmonToggler).check({ force: true });

      // заполняем required поля формы

      cy.get($SaveProjectButton).click({ force: true });
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
