context('HostLimit', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const testNumber = 123;

   const $hostLimitSection = 'div[data-e2e="host_limits"]';
   const $buttonText = `${$hostLimitSection} .button2__text`;
   const $inputLimit = `${$hostLimitSection} input[name="max_healing_cancellations"]`;

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Edit HostLimit', () => {
      // response
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      // request
      cy.intercept('v1/projects/sandbox-mtn/host_limits', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               'max_healing_cancellations': [
                  { 'limit': 1, 'period': '1h' },
                  { 'limit': 3, 'period': '7d' },
                  { 'limit': testNumber, 'period': '1d' },
               ],
               'reason': '',
            });
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($buttonText).contains('Add condition').click({ force: true });

      cy.get($buttonText).contains('Delete').eq(0).click({ force: true });
      cy.get($inputLimit).eq(-1).type('{selectall}').type(testNumber);

      cy.get($SaveProjectButton).click();
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
