context('CreateNewShortProject', () => {
   // buttons
   const $CreateProjectButton = '[data-e2e="NewProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   // fields
   const $TypeField = '[data-e2e="TypeField:type"]';
   const $ProjectNameField = 'input[name="name"]';
   const $ProjectSlugField = 'input[name="id"]';
   const $AbcServiceField = 'input[placeholder="ABC service slug"]';
   const $DeployConfigField = 'input[name="deployConfig"]';
   const $FolderID = 'input[name="yc_iam_folder_id"]';
   const $AutomationPlot = '[data-e2e="AutomationPlotField:automation_plot"]';

   // values
   const testString = 'rtc';
   const testSuggestString = 'sandbox-ci';
   const deploy_config = '2hdd-2ssd-search-ubuntu-14.04';
   const automation = 'RTC';

   const $suggestItem = '.yc-suggest__item > div';

   before(() => {
      cy.clearCookies();

      cy.intercept('GET', /\/boxes$/, {
         fixture: 'boxes',
      }).as('boxes');

      cy.intercept('GET', /\/hosts\?([\w\d.-]+?)/, {
         fixture: 'hosts',
      }).as('hosts');

      cy.intercept('GET', /\/projects\?([\w\d.-]+?)/, {
         fixture: 'projects',
      }).as('projects');

      cy.intercept('GET', /\/automation-plot\/\?([\w\d.-]+?)/, {
         fixture: 'automation-plot',
      }).as('automation-plot');

      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Open Modal', () => {
      cy.visit('/', {
         onBeforeLoad: function (window) {
            window.localStorage.setItem('settings.api.preset', JSON.stringify('mock'));
            window.localStorage.setItem('settings.installation.preset', JSON.stringify('external'));
         },
      });

      cy.wait('@hosts');
      cy.wait('@projects');

      cy.get($CreateProjectButton).click();

      cy.wait('@automation-plot');
   });

   it('Create Project', () => {
      cy.intercept('GET', /\/external_api\/abc\/services?([\w\d.-]+?)/, {
         fixture: 'suggestAbcProject',
      }).as('getSuggestions');
      cy.intercept('GET', /\/v1\/bot-projects$/, {
         fixture: 'bot-projects',
      }).as('bot-projects');
      cy.intercept('GET', /\/deploy-configs$/, {
         fixture: 'deploy-configs',
      }).as('deploy-configs');

      cy.intercept('POST', 'v1/projects', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               automation_plot_id: testString,
               bot_project_id: 100008645,
               deploy_config,
               deploy_network: 'project',
               id: testString,
               name: testString,
               provisioner: 'lui',
               reason: '',
               yc_iam_folder_id: testString,
               type: 'vm',
            });
         }
      }).as('createProject');

      cy.get($TypeField).click();
      cy.get('.menu__text').contains('vm').click({ force: true });

      cy.get($ProjectNameField).type(testString);
      cy.get($ProjectSlugField).type(testString);

      cy.get($AbcServiceField).type(testSuggestString);
      cy.wait('@getSuggestions');
      cy.wait('@bot-projects');
      cy.get($suggestItem).contains(testSuggestString).click();

      cy.get($FolderID).type(testString);

      cy.get($DeployConfigField).click();
      cy.wait('@deploy-configs');
      cy.get('.menu__text').contains(deploy_config).click({ force: true });
      cy.get($DeployConfigField).click();

      cy.get($AutomationPlot).click();
      cy.get('.menu__text').contains(automation).click({ force: true });

      cy.get($SubmitButton).click();

      cy.wait('@createProject');
   });
});
