context('BooleanSwitcherField:reboot_via_ssh', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const $rebootViaSsh = 'input[name="reboot_via_ssh"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      cy.intercept('GET', /hbf-projects$/, {
         fixture: 'suggestHbfProject',
      }).as('getSuggestHbfProject');
   });

   it('Check request with BooleanSwitcherField on/off', () => {
      cy.intercept('PUT', 'v1/projects/sandbox-mtn/rebooting_via_ssh').as('updateProject_shhOn');
      cy.intercept('DELETE', 'v1/projects/sandbox-mtn/rebooting_via_ssh').as('updateProject_shhOFF');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($rebootViaSsh).click({ force: true });
      cy.get($rebootViaSsh).should('be.checked');

      cy.get($SaveProjectButton).click({ force: true });
      cy.get($SubmitButton).click();
      cy.wait('@updateProject_shhOn');

      cy.get($rebootViaSsh).click({ force: true });
      cy.get($rebootViaSsh).should('not.be.checked');

      cy.get($SaveProjectButton).click({ force: true });
      cy.get($SubmitButton).click();

      cy.wait('@updateProject_shhOFF');
   });
});

context('ConstantSelectField:tier', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const $tierSelect = 'div[data-e2e="ConstantSelectField:tier"] button';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      cy.intercept('GET', /hbf-projects$/, {
         fixture: 'suggestHbfProject',
      }).as('getSuggestHbfProject');
   });

   it('Check request with tier: 4', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn/tier', req => {
         if (req.body) {
            expect(req.body['tier']).equal(4);
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($tierSelect).click();

      cy.get('.menu__text').contains(4).click();

      // заполняем required поля формы

      cy.get($SaveProjectButton).click({ force: true });
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
