context('SortableTable', () => {
   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/v1\/hosts\?([\w\d.-]+?)/, {
         result: []
      }).as('hosts');
   });

   it('Check name:asc request', () => {
      cy.intercept('GET',/\/v1\/hosts\?([\w\d.-]+?)/, (req) => {
         if (req.body) {
            expect(req.body['sort-by']).equal('name:asc')
         }
      }).as('name:asc')

      cy.visit('/projects');

      cy.get('thead th').eq(1).click()

      cy.wait('@name:asc')
   });
   it('Check name:desc request', () => {
      cy.intercept('GET',/\/v1\/hosts\?([\w\d.-]+?)/, (req) => {
         if (req.body) {
            expect(req.body['sort-by']).equal('name:desc')
         }
      }).as('name:desc')

      cy.get('thead th').eq(1).click()

      cy.wait('@name:desc')
   })

   it('Check name:asc, project:asc request', () => {
      cy.intercept('GET',/\/v1\/hosts\?([\w\d.-]+?)/, (req) => {
         if (req.body) {
            expect(req.body['sort-by']).equal('name:asc,project:asc')
         }
      }).as('name:asc,project:asc')

      cy.get('thead th').eq(1).dblclick()
      cy.get('thead th').eq(2).click()

      cy.wait('@name:asc,project:asc')
   })
});
