context('VlansForm:use_fastbone', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]';
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]';
   const $SubmitButton = 'button[type="submit"]';

   const $useFastboneToggler = 'input[name="use_fastbone"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn',
      }).as('sandbox-mtn');

      cy.intercept('GET', /hbf-projects$/, {
         fixture: 'suggestHbfProject',
      }).as('getSuggestHbfProject');
   });

   it('Check request with use_fastbone: false', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn/hbf_project_id', req => {
         if (req.body) {
            expect(req.body['use_fastbone']).equal(false);
         }
      }).as('updateProject');

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn');

      cy.mockSwitcher();

      cy.get($EditProjectButton).click();

      cy.get($useFastboneToggler).uncheck({ force: true });

      // заполняем required поля формы

      cy.get($SaveProjectButton).click({ force: true });
      cy.get($SubmitButton).click();

      cy.wait('@updateProject');
   });
});
