context('CreateScenario:Advanced', () => {
   const $suggestList = '.yc-suggest__item span';

   const testNumber = '123';
   const testString = 'rtc';

   const $inputTicket = 'input[placeholder="Ticket id"]';
   const $inputName = 'input[placeholder="Enter scenario name"]';
   const $suggestProject = 'input[placeholder="Select project"]';
   const $textareaHosts = 'textarea[name="hosts"]';

   const $checkAdvanced = 'label[for="_advanced"] .yc-arrow-toggle';
   const $inputIdleTime = 'input[name="script_args.idle_time"]';
   const $checkWorkdays = 'input[name="script_args.workdays_only"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Edit advanced settings', () => {
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($checkAdvanced).click({ force: true });
      cy.get($inputIdleTime).type(testNumber);

      cy.get($checkWorkdays).uncheck();
      cy.get($checkWorkdays).check();
   });

   it('Check request', () => {
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            console.log(req.body);
            expect(req.body.script_args).to.deep.equal({
               delete: false,
               idle_time: Number(testNumber),
               target_project_id: 'rtc-mtn-test',
               workdays_only: true,
            });
         }
      }).as('createScenario');
      cy.intercept('GET', `https://st-api.yandex-team.ru/v2/issues/_suggest?input=${testString}`, { body: [] }).as(
         'getSuggestionsTicket',
      );

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      cy.get($textareaHosts).type(testString);

      cy.get($suggestProject).type(testString, { force: true });
      cy.get($suggestList).contains(testString).click();

      cy.get('button[type=submit]').click();

      cy.wait('@getSuggestionsTicket');
      cy.wait('@createScenario');
   });
});
