context('ScenarioWithMaintance', () => {
   const testString = 'rtc';

   const $scenarioTypeSelect = '.yc-select-control__tokens-text';
   const $scenarioTypeSelectItem = 'div[data-value="itdc-maintenance"]';

   const $inputTicket = 'input[placeholder="Ticket id"]';
   const $inputName = 'input[placeholder="Enter scenario name"]';
   const $textareaHosts = 'textarea[name="hosts"]';

   const $maintanceStart = 'input[name="_scheduledMaintance"][value="start"]';
   const $maintanceRange = 'input[name="_scheduledMaintance"][value="range"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.clock(new Date('2021-08-09T11:00:00+03:00'));
   });

   it('With Start time', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body.script_args).to.deep.equal({
               maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceStart).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      cy.get($textareaHosts).type(testString);

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });

   it('With Time range', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body.script_args).to.deep.equal({
               maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
               maintenance_end_time: Math.floor(new Date('2021-08-10T12:00:00+03:00').getTime() / 1000),
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceRange).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      cy.get($textareaHosts).type(testString);

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });
});
