context('Scenario', () => {
   const testString = 'rtc';

   const $scenarioTypeSelect = '.yc-select-control__tokens-text';
   const $scenarioTypeSelectItem = 'div[data-value="noc-hard"]';

   const $inputTicket = 'input[placeholder="Ticket id"]';
   const $inputName = 'input[placeholder="Enter scenario name"]';
   const $resourcesTypeHosts = 'input[name="_resourceType"][value="hosts"]';
   const $resourcesTypeSwitch = 'input[name="_resourceType"][value="switch"]';
   const $inputSwitch = 'input[placeholder="Enter switch"]';
   const $inputHosts = 'textarea[placeholder="Enter host name"]';
   const $checkboxAutoStart = 'input[name="autostart"]';

   const $maintanceDisabled = 'input[name="_scheduledMaintance"][value="disabled"]';
   const $maintanceStart = 'input[name="_scheduledMaintance"][value="start"]';
   const $maintanceRange = 'input[name="_scheduledMaintance"][value="range"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();
      cy.clock(new Date('2021-08-09T11:00:00+03:00'));
   });

   it('With Time range', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: true,
               name: 'rtc',
               scenario_type: 'noc-hard',
               script_args: {
                  maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
                  maintenance_end_time: Math.floor(new Date('2021-08-10T12:00:00+03:00').getTime() / 1000),
               },
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceRange).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });

   it('With Start time', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: true,
               name: 'rtc',
               scenario_type: 'noc-hard',
               script_args: {
                  // switch: 'rtc',
                  maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
               },
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceStart).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      // cy.get($inputSwitch).type(testString);

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });

   it('With Disabled time and Autostart', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: false,
               name: 'rtc',
               scenario_type: 'noc-hard',
               // script_args: { switch: 'rtc' },
               script_args: {},
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceDisabled).click();

      // заполняем поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      // cy.get($inputSwitch).type(testString);
      cy.get($checkboxAutoStart).uncheck();

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });

   it('With Switch', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: true,
               name: 'rtc',
               scenario_type: 'noc-hard',
               script_args: {
                  switch: 'rtc',
                  maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
                  maintenance_end_time: Math.floor(new Date('2021-08-10T12:00:00+03:00').getTime() / 1000),
               },
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceRange).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });

      cy.get($resourcesTypeSwitch).click();
      cy.get($inputSwitch).type(testString);

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });
   it('With hosts', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: true,
               hosts: ['rtc'],
               name: 'rtc',
               scenario_type: 'noc-hard',
               script_args: {
                  maintenance_start_time: Math.floor(new Date('2021-08-10T11:00:00+03:00').getTime() / 1000),
                  maintenance_end_time: Math.floor(new Date('2021-08-10T12:00:00+03:00').getTime() / 1000),
               },
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      cy.get($maintanceRange).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });

      cy.get($resourcesTypeHosts).click()
      cy.get($inputHosts).type(testString);

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });
});
