context('Scenario', () => {
   const testString = 'rtc';

   const $scenarioTypeSelect = '.yc-select-control__tokens-text';
   const $scenarioTypeSelectItem = 'div[data-value="noc-soft"]';

   const $inputTicket = 'input[placeholder="Ticket id"]';
   const $inputName = 'input[placeholder="Enter scenario name"]';
   const $inputSwitch = 'input[name="script_args.switch"]';
   const $checkboxAutoStart = 'input[name="autostart"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Create NOC-Soft with Autostart', () => {
      // response
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.visit('/scenarios');

      //request
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               autostart: true,
               name: 'rtc',
               scenario_type: 'noc-soft',
               script_args: { switch: 'rtc' },
               ticket_key: 'rtc',
            });
         }
      }).as('createScenario');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      // заполняем поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      cy.get($inputSwitch).type(testString);
      cy.get($checkboxAutoStart).check();

      // submit
      cy.get('button[type=submit]').click({force: true});

      // listeners
      cy.wait('@createScenario');
   });
});
