context('CreateScenario', () => {
   const $suggestList = '.yc-suggest__item span';

   const testString = 'rtc';

   const $scenarioTypeSelect = '.yc-select-control__tokens-text';
   const $scenarioTypeSelectItem = 'div[data-value="reserved-hosts-transfer"]';

   const $inputTicket = 'input[placeholder="Ticket id"]';
   const $inputName = 'input[placeholder="Enter scenario name"]';
   const $suggestProject = 'input[placeholder="Select project"]';
   const $textareaHosts = 'textarea[name="hosts"]';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check request', () => {
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.intercept('GET', `https://st-api.yandex-team.ru/v2/issues/_suggest?input=${testString}`, { body: [] }).as(
         'getSuggestionsTicket',
      );

      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            console.log(req.body);
            expect(req.body).to.deep.equal({
               'name': testString,
               'hosts': [testString],
               'autostart': false,
               'scenario_type': 'reserved-hosts-transfer',
               'ticket_key': testString,
               'script_args': {
                  'delete': false,
                  'target_project_id': 'rtc-mtn-conductordb',
               },
            });
         }
      }).as('createScenario');

      cy.visit('/scenarios');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($scenarioTypeSelect).contains('hosts-transfer').click();
      cy.get($scenarioTypeSelectItem).click();

      // заполняем required поля формы
      cy.get($inputTicket).type(testString);
      cy.get($inputName).type(testString, { force: true });
      cy.get($textareaHosts).type(testString);

      cy.get($suggestProject).type(testString, { force: true });
      cy.get($suggestList).contains(testString).click();

      cy.get('button[type=submit]').click({force: true});

      cy.wait('@getSuggestionsTicket');
      cy.wait('@createScenario');
   });
});
