context('FinishScenarioAction', () => {
   const $btnModalOk = 'button[data-e2e="Modal:ok"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Finish button in ITDC', () => {
      // response
      cy.intercept('GET', /\/scenarios\/6915\?([\w\d.-]+?)/, {
         fixture: 'scenario-itdc',
      }).as('scenario-itdc');
      cy.intercept('POST', /\/get-hosts\?([\w\d.-]+?)/, {
         result: [],
      }).as('hosts');

      // request
      cy.intercept('PATCH', /\/scenarios\/6915$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ 'labels': { 'WORK_COMPLETED': 'true' }, reason: '' });
         }
      }).as('finish');

      cy.visit('/scenarios/6915');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Finish').click({ force: true });
      cy.get('.modal__content').should('exist');

      cy.get($btnModalOk).click();
      cy.wait('@finish');
   });

   it('Finish button in NOC-Hard', () => {
      // response
      cy.intercept('GET', /\/scenarios\/6840\?([\w\d.-]+?)/, {
         fixture: 'scenario-noc-hard',
      }).as('scenario-noc-hard');
      cy.intercept('POST', /\/get-hosts\?([\w\d.-]+?)/, {
         result: [],
      }).as('hosts');

      // request
      cy.intercept('PATCH', /\/scenarios\/6840$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ 'labels': { 'WORK_COMPLETED': 'true' }, reason: '' });
         }
      }).as('finish');

      cy.visit('/scenarios/6840');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Finish').click({ force: true });
      cy.get('.modal__content').should('exist');

      cy.get($btnModalOk).click();
      cy.wait('@finish');
   });

   it('Finish button in NOC-Soft', () => {
      // response
      cy.intercept('GET', /\/scenarios\/6840\?([\w\d.-]+?)/, {
         fixture: 'scenario-noc-soft',
      }).as('scenario-noc-soft');
      cy.intercept('POST', /\/get-hosts\?([\w\d.-]+?)/, {
         result: [],
      }).as('hosts');

      // request
      cy.intercept('PATCH', /\/scenarios\/6840$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ 'labels': { 'WORK_COMPLETED': 'true' }, reason: '' });
         }
      }).as('finish');

      cy.visit('/scenarios/6840');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Finish').click({ force: true });
      cy.get('.modal__content').should('exist');

      cy.get($btnModalOk).click();
      cy.wait('@finish');
   });
});
