context('SkipScenarioAction', () => {
   const $btnModalOk = 'button[data-e2e="Modal:ok"]'

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Click Skip button', () => {
      cy.intercept('GET', /\/scenarios\/169\?([\w\d.-]+?)/, {
         fixture: 'scenario-host-transfer'
      }).as('scenario-host-transfer')
      cy.intercept('POST', /\/get-hosts\?([\w\d.-]+?)/, {
         result: []
      }).as('hosts')

      cy.visit('/scenarios/169');

      cy.mockSwitcher()

      cy.get('.yc-button__text').contains('Skip').click({ force: true });
   })

   it('Check request', () => {
      cy.intercept('POST', /\/scenarios\/169\/apply-action$/, (req) => {
         if (req.body) {
            expect(req.body).to.deep.equal({ action: "skip_wait_stage_for_hosts_transfer", reason: "" })
         }
      }).as('skipPause')

      cy.get($btnModalOk).click()

      cy.wait('@skipPause')
   });
});
