context('HbfProjectInput', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]'
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]'
   const $SubmitButton = 'button[type="submit"]'

   const $suggestField = '.yc-text-input__control[placeholder="Select MTN"]'

   const testString = '5230'


   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn'
      }).as('sandbox-mtn')

      cy.intercept('GET', /hbf-projects$/, {
         fixture: 'suggestHbfProject'
      }).as('getSuggestHbfProject')

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn')

      cy.mockSwitcher()

      cy.get($EditProjectButton).click()

      cy.get($suggestField).clear()
      cy.get($suggestField).type(testString)
      cy.get($suggestField).should((el) => {
         expect(el.val()).include(testString)
      })

      cy.wait('@getSuggestHbfProject')
   })

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist')
   })

   it('Check request', () => {
      cy.intercept('PATCH', 'v1/projects/sandbox-mtn/hbf_project_id', (req) => {
         if (req.body) {
            expect(req.body.hbf_project_id).include(testString)
         }
      }).as('updateProject')

      // заполняем required поля формы

      cy.get($SaveProjectButton).click()
      cy.get($SubmitButton).click()

      cy.wait('@updateProject')
   });
});
