Cypress.Commands.add('login', (login: string, passwd: string) => {
   cy.request({
      body: { retpath: encodeURIComponent(Cypress.env('baseUrl')), login, passwd },
      followRedirect: false,
      form: true,
      log: true,
      method: 'POST',
      url: Cypress.env('passport'),
   });
});

let authorized = false;

Cypress.Commands.add('loginRobot', () => {
   if (authorized) {
      return;
   }

   cy.login(Cypress.env('ROBOT_LOGIN'), Cypress.env('ROBOT_PASSWORD'));
   authorized = true;
});

Cypress.Commands.add('envConfig', () => {
   cy.window().then(w => w.YC.envConfig);
});

Cypress.Commands.add('baseIntercept', () => {
   cy.intercept('GET', /\/user$/, {
      fixture: 'user',
   }).as('user');
   cy.intercept('GET', /\/csrf-token$/, {
      fixture: 'csrf-token',
   }).as('csrf-token');
   cy.intercept('GET', /\/constants$/, {
      fixture: 'constants',
   }).as('constants');

   cy.intercept('GET', /\/projects\/([\w\d.-]+?)\/requested_owners_with_request_id$/, {
      'result': { 'khoden': 13850549 },
   }).as('sandbox-requested_owners_with_request_id');
   cy.intercept('GET', /\/projects\/([\w\d.-]+?)\/revoking_owners_with_request_id$/, {
      'result': { 'khoden': 13850549 },
   }).as('sandbox-requested_owners_with_request_id');
});

Cypress.Commands.add('mockSwitcher', () => {
   // переход на mock c помощью apiSwitcher
   cy.get('input[value="mock"]').click();
});

Cypress.Commands.add('internalSwitcher', () => {
   // переход на mock c помощью apiSwitcher
   cy.get('input[value="internal"]').click();
});

Cypress.Commands.add('externalSwitcher', () => {
   // переход на mock c помощью apiSwitcher
   cy.get('input[value="external"]').click();
});

Cypress.Commands.add('emptyPage', () => {
   cy.visit('/about');
});

Cypress.Commands.add('locationUrl', () => {
   cy.location().then(l => l.href.replace(l.origin, ''));
});

Cypress.on('uncaught:exception', (err, runnable) => {
   // returning false here prevents Cypress from
   // failing the test
   return false;
});
