// in cypress/support/index.d.ts
// load type definitions that come with Cypress module
/// <reference types="cypress" />

interface TestActions {
   createStage(stage: any): Promise<boolean>;

   deleteStage(stageName: string): Promise<boolean>;

   createProject(project: any): Promise<boolean>;

   deleteProject(projectName: string): Promise<boolean>;

   createRelease(release: any): Promise<boolean>;

   deleteRelease(releaseName: string): Promise<boolean>;

   /**
    * Открывает страницу средствами роутинга приложения (т.е. без перезагрузки)
    *
    * Перед вызовом нужно убедиться, что хотя бы одна страница открыта.
    */
   pushUrl(path: string): void;
}

interface ClusterConfig {
   title: string;
   value: string;
}

interface EnvConfig {
   authorizePath: string;
   avatarHost: string;
   blackboxHost: string;
   clck: string;
   clusters: ClusterConfig[];
   deployEngine: string;
   deployRobots: string[];
   envName: string;
   feedbackFormId: number | null;
   idmSystemName: string;
   nannyUiDomain: string;
   passportHost: string;
   resignPath: string;
   serviceWorkerRefreshIntervalMinutes: number;
   services: {
      name: string;
      endpoint: string;
   }[];
   yasmPush: string;
}

interface YandexConfig {
   envConfig: EnvConfig;
   metrika: string;
   now: string;
   user: { uid: string; login: string };
   version: string;
}

interface Window {
   YC: YandexConfig;
   testActions: TestActions;
}

declare namespace Cypress {
   interface Chainable {
      createProject(projectName: string): Chainable<boolean>;

      createSimpleStage(stageName: string, project?: string, accountId?: string): Chainable<boolean>;

      createStageWithStatic(stageName: string, project?: string, accountId?: string): Chainable<boolean>;

      deleteProject(projectName: string): Chainable<boolean>;

      deleteStage(stageName: string): Chainable<boolean>;

      createRelease(stageName: string, releaseName: string): Chainable<boolean>;

      deleteRelease(releaseName: string): Chainable<boolean>;

      emptyPage(): Chainable;

      envConfig(): Chainable<EnvConfig>;

      locationUrl(): Chainable<string>;

      login(login: string, passwd: string): Chainable<void>;

      loginRobot(): Chainable;

      baseIntercept(): Chainable;

      mockSwitcher(): Chainable;

      internalSwitcher(): Chainable;

      externalSwitcher(): Chainable;

      pushUrl(path: string): Chainable;

      testActions(): Chainable<TestActions>;
   }
}
