export const DEFAULT_PROJECT = 'deploy-e2e';

export const DEFAULT_ACCOUNT_ID = 'abc:service:3494';

export const DEFAULT_NETWORK = '_YA_DEPLOY_NETS_';

export const TIMES_IN_S = {
   Second: 1,
   Minute: 60,
   Hour: 60 * 60,
   Day: 60 * 60 * 24,
   Week: 60 * 60 * 24 * 7,
};

export const TIMES_IN_MS = {
   Millisecond: 1,
   Second: 1000 * TIMES_IN_S.Second,
   Minute: 1000 * TIMES_IN_S.Minute,
   Hour: 1000 * TIMES_IN_S.Hour,
   Day: 1000 * TIMES_IN_S.Day,
   Week: 1000 * TIMES_IN_S.Week,
};

export const TIMEOUTS = {
   // presets

   /* 1 c - элемент уже должен быть на странице */
   immediately: TIMES_IN_MS.Second,

   /* 5 c - элемент либо уже есть, либо вот-вот будет (легкий API-запрос) */
   fast: 5 * TIMES_IN_MS.Second,

   /* 10 c - элемент скоро будет (тяжелый API-запрос) */
   slow: 10 * TIMES_IN_MS.Second,

   // forced. Значения, больше 30 секунд должны определятся явно для каждого случая.
   /**
    * Андрей Староверов:
    *
    * Поставьте 20 сек, если можете. Главное не создавать новый стейдж сразу после удаления.
    *
    * Это недостаток наследования ACL через stagectl, которое уйдет при переходе на наследование в YP.
    *
    * Если ты удалишь сразу после создания, то тоже ошибка будет,
    * потому что контроллеры не успеют твой стейдж подхватить, но это ретраями лечится хотя бы.
    */
   beforeRecreateStage: 20 * TIMES_IN_MS.Second,

   /**
    * Андрей Староверов:
    *
    * Можешь удалять проект не сразу после создания, а подождать секунд 20-30? 30с точно должно хватить.
    * Там суть в том, что Auth проиндексировал создание, а когда захотел роль накинуть, то проект уже удалили
    */
   beforeDeleteNewProject: 60 * TIMES_IN_MS.Second,

   stageReadyAfterSave: 10 * TIMES_IN_MS.Minute,
   afterPassport: 2 * TIMES_IN_MS.Second,
   waitStageAcl: 30 * TIMES_IN_MS.Second,
};

const ENTITY_PREFIX = Cypress.env('entityPrefix') ?? Cypress.env('ROBOT_LOGIN') ?? 'robot-infracloudui';

export function getStageName(stageName: string) {
   return `e2e_${ENTITY_PREFIX}_${stageName}`;
}

export function getProjectName(projectName: string) {
   return `e2e_${ENTITY_PREFIX}_${projectName}`;
}

export const SECRET = {
   name: 'aaa_testcafe_deploy',
   keys: ['PORT', 'TVM_SOURCE_1', 'TVM_SOURCE_2'],
};
