export const data = (key: string, value: string) => `[data-${key}="${value}"]`;

export const dataTest = (testId: string) => data('test', testId);

export const dataE2E = (testId: string) => data('e2e', testId);

export const testCss = (testId: string) => `.test-${testId}`;

export const fieldControl = (labelFor: string, selector = '> *:first-child') =>
   `label[for="${labelFor}"] + div ${selector}`;

export const sel = (...parts: string[]) => parts.join(' ');

export const getInputValue = <T = string>(selector: string): Promise<T> =>
   new Promise(resolve => cy.get(selector).then($input => resolve(($input.val() as any) as T)));
