const {patch} = require('./utils');

patch(
   './build/index.html',
   body => {
      const config = require('../deploy/ui_config.khoden.json');

      return body.replace(
         /<script id="ui-config"><\/script>/,
         `<script>window.UI_CONFIG = ${JSON.stringify(config, null, 2)}</script>`,
      );
   },
);

patch(
   './build/_storybook/iframe.html',
   body => {
      const config = require('../deploy/ui_config.khoden.json');

      return body.replace(
         /<\/head>/,
         `<script>window.UI_CONFIG = ${JSON.stringify(config, null, 2)}</script></head>`,
      );
   },
);
