const fs = require('fs');

/**
 * Патчит файл, изменяя его контент произвольным образом
 *
 * @example
 *    patch(
 *       './package.json',
 *       body => body.replace(/"version": "[\d.]+"/, '"version": "1.0.1")
 *    )'
 *
 * @param path путь до файла, который патчится
 * @param transforms произвольное число функций, которые принимают и возвращают текстовый контент файла
 */
function patch(path, ...transforms) {
   console.log('Patching', path);

   let body = fs.readFileSync(path, {encoding: 'utf-8'});

   for (const transform of transforms) {
      body = transform(body);
   }

   fs.writeFileSync(path, body);
}

module.exports = {patch};
