const {getUrlPath} = require('./helpers');

module.exports = class FakeApi {
   constructor() {
      this._handlers = {
         DELETE: [],
         GET: [],
         PATCH: [],
         POST: [],
         PUT: [],
      };
      this._maxDelay = 300;
   }

   whenGET(urlRe, response, code = 200, delay = null) {
      this._handlers.GET.push({urlRe, response, code, delay});
   }

   whenPATCH(urlRe, response, code = 201, delay = null) {
      this._handlers.PATCH.push({urlRe, response, code, delay});
   }

   whenPOST(urlRe, response, code = 201, delay = null) {
      this._handlers.POST.push({urlRe, response, code, delay});
   }

   whenPUT(urlRe, response, code = 200, delay = null) {
      this._handlers.PUT.push({urlRe, response, code, delay});
   }

   whenDELETE(urlRe, response, code = 200, delay = null) {
      this._handlers.DELETE.push({urlRe, response, code, delay});
   }

   handleRequest(req, res) {
      this._getHttpResponse(req)
         .then(resp => {
            res.status(resp.status);
            res.send(resp.body);
         });
   }

   _getHttpResponse(req) {
      const urlPath = getUrlPath(req.url);

      let body = {errorMessage: `Mock for ${req.method} ${urlPath} not defined`};
      let status = 405;
      let delay = Math.random() * this._maxDelay;

      const handler = this._handlers[req.method].find(h => h.urlRe.test(urlPath));

      if (handler) {
         if (typeof handler.response === 'function') {
            [status, body] = handler.response(req.url, req.body);
         } else {
            body = handler.response;
            status = handler.code;
         }

         if (handler.delay) {
            delay = handler.delay;
         }
      }

      return new Promise(resolve => {
         setTimeout(() => {
            console.log(`${req.method} ${urlPath}`, '->', status);
            resolve({body, status, url: req.url});
         }, delay);
      });
   }
};
