const fs = require('fs');

function deepJsonClone(obj) {
   return JSON.parse(JSON.stringify(obj));
}

function getFileContent(path) {
   return fs.readFileSync(path, {encoding: 'UTF-8'});
}

function getUrlPath(url) {
   return new URL(`http://localhost${url}`).pathname;
}

function takeFirstN(list, predicate, limit) {
   const result = [];

   for (const item of list) {
      if (predicate(item)) {
         result.push(item);

         if (result.length >= limit) {
            return result;
         }
      }
   }

   return result;
}

function rand(limit) {
   return Math.round(Math.random() * (limit > 0 ? limit - 1 : 0));
}

function sample(list) {
   return list[rand(list.length)];
}

/**
 * Прогоняет данные (один аргумет) через цепочку функций
 */
function flow(...functionList) {
   return (data) => {
      for (const f of functionList) {
         data = f(data);
      }

      return data;
   };
}

module.exports = {
   deepJsonClone,
   flow,
   sample,
   getFileContent,
   getUrlPath,
   takeFirstN,
};
