const fs = require('fs');
const https = require('https');
const express = require('express');
const cors = require('cors');

const FakeApi = require('./fake_api');

const MocksService = require('./mocks');

const app = express();
app.use(
   cors({
      credentials: true,
      origin: (origin, callback) => callback(null, true),
   }),
);
app.use(express.json());

const fakeApi = new FakeApi();
const mocks = new MocksService(fakeApi);
mocks.init();

app.all('/*', fakeApi.handleRequest.bind(fakeApi));

// HTTPS server
const certificate = fs.readFileSync('../deploy/localhost.yandex-team.ru.crt', 'utf8');
const privateKey = fs.readFileSync('../deploy/localhost.yandex-team.ru.key', 'utf8');

const credentials = { key: privateKey, cert: certificate };
const httpsServer = https.createServer(credentials, app);

httpsServer.listen(3002, () => console.log('Mock server listening on port 3002 (HTTPS)!'));
