import * as path from 'path';
import alias from '@rollup/plugin-alias';
import resolve from '@rollup/plugin-node-resolve';
import commonjs from '@rollup/plugin-commonjs';
import json from '@rollup/plugin-json';

export default {
   input: 'src/index.js',
//    external: ['mock-aws-s3'],
   output: {
      file: 'dist/index.js',
      format: 'cjs', // immediately-invoked function expression — suitable for <script> tags
      sourcemap: false,
   },
   plugins: [
      //       alias({
      //          entries: [
      //             { find: 'mock-aws-s3', replacement: 'wtf' },
      //         //     { find: 'batman-1.0.0', replacement: './joker-1.5.0' },
      //          ],
      //       }),
      resolve(), // tells Rollup how to find date-fns in node_modules
      commonjs({
         include: ['src/**', '@yandex-data-ui/**', './**'],
         //  exclude: ['node_modules/mock-aws-s3/**'],
      }), // converts date-fns to ES modules
      json(),
   ],
};
