const Schema = require('@yandex-data-ui/cloud-schemas').default;

module.exports = {
   env: 'ext-preprod',
   enableUnauthorized: true,
   rum: {
      project: 'wall-e-yc',
      env: 'pre_production',
   },
   serviceAccountId: process.env.SA_ID,
   serviceAccountKeyId: process.env.SA_KEY_ID,
   serviceAccountPrivateKey: process.env.SA_PRIVATE_KEY,
   tokenServiceEndpoint: Schema.iam.endpoints.external.testing.tokenService.path,
   sessionServiceEndpoint: Schema.oauth.endpoints.external.testing.sessionService.path,
   oauthEndpoint: 'https://auth-preprod.cloud.yandex.ru',
   walleEndpoint: 'https://api.wall-e.cloud-preprod.yandex.net',
   errorBooster: {
      server: {
         enabled: true,
      },
   },
};
