const Schema = require('@yandex-data-ui/cloud-schemas').default;

module.exports = {
   env: 'ext-prod',
   enableUnauthorized: true,
   rum: {
      project: 'wall-e-yc',
      env: 'production',
   },
   serviceAccountId: process.env.SA_ID,
   serviceAccountKeyId: process.env.SA_KEY_ID,
   serviceAccountPrivateKey: process.env.SA_PRIVATE_KEY,
   tokenServiceEndpoint: Schema.iam.endpoints.external.production.tokenService.path,
   sessionServiceEndpoint: Schema.oauth.endpoints.external.production.sessionService.path,
   oauthEndpoint: 'https://auth.cloud.yandex.ru',
   walleEndpoint: 'https://api.wall-e.cloud.yandex.net',
   errorBooster: {
      server: {
         enabled: true,
      },
   },
};
