const proxy = require('express-http-proxy');
const envConfig = require('../configs/env');

module.exports = proxy(envConfig.walleEndpoint, {
   proxyReqPathResolver: function (req) {
      var parts = req.url.split('?');
      var queryString = parts[1];
      var updatedPath = parts[0].replace(/api/, '/');
      return updatedPath + (queryString ? '?' + queryString : '');
   },
   proxyReqOptDecorator: function (proxyReqOpts, srcReq) {
      proxyReqOpts.headers['Authorization'] = `Bearer ${srcReq.res.locals.iamToken}`;
      return proxyReqOpts;
   },
});
