const Core = require('@yandex-data-ui/core');

const envConfig = require('./configs/env');
const { sessionServiceMiddleware } = require('./middlewares/session-service');

const app = new Core({ name: 'wall-e' });

app.setupHealthcheck({
   path: '/ping',
   handler: (_, res) => {
      res.send('pong!');
   },
});

if (envConfig.enableUnauthorized) {
   process.env.NODE_TLS_REJECT_UNAUTHORIZED = '0';
}

app.registerAuthMethod({
   name: 'session-service',
   fn: sessionServiceMiddleware(app),
});

app.run();

module.exports = app;
