const { prepareSessionServiceMiddleware } = require('@yandex-data-ui/core/build/plugins/session-service');
const envConfig = require('../configs/env');

module.exports = {
   sessionServiceMiddleware: app =>
      prepareSessionServiceMiddleware(app.utils, {
         force: true,
         sessionServiceEndpoint: envConfig.sessionServiceEndpoint,
         oauthEndpoint: `${envConfig.oauthEndpoint}/oauth`,
         oauthClientId: app.config.oauthClientId,
         oauthClientSecret: app.config.oauthClientSecret,
         serviceAccountSettings: {
            serviceAccountId: envConfig.serviceAccountId,
            serviceAccountKeyId: envConfig.serviceAccountKeyId,
            serviceAccountPrivateKey: envConfig.serviceAccountPrivateKey,
            tokenServiceEndpoint: envConfig.tokenServiceEndpoint,
         },
         authCallbacks: {
            onAuthSuccess(req, res, next) {
               const { iam = {} } = res.locals;
               res.locals.credentials = { token: iam.token };

               if (req.body.uid && req.body.uid !== res.locals.passport?.uid) {
                  req.ctx.log('NEED_RESET', iam);

                  return res.status(401).send({ code: 'NEED_RESET' });
               }

               return next();
               // return res.send({ code: 'SUCCESS', response: res.locals });
            },

            onAuthFailed(error, req, res) {
               // req.ctx.logError('Get iam credentials denied', error, {
               //    user: _.get(res, ['locals', 'iam']),
               // });

               // return res.send(errorView({ req, res }));
               return res.send({ code: 'ERROR', error: error.message });
            },

            onXhrAuthFailed(error, req, res) {
               req.ctx.log('NEED_RESET - auth failed for xhr request', error);
               return res.status(401).send({ code: 'NEED_RESET' });
            },
         },
      }),
};
