import { RadioButton } from '@yandex-data-ui/common';
import React from 'react';
import { useCallback } from 'react';

import { config } from '../services';
import { ApiPreset, WALLE_API_URLS } from '../services/config';

export const ApiPresetSwitcher: React.FC = () => {
   const handleChange = useCallback((v: string) => {
      config.apiPreset = v as ApiPreset;

      window.location.reload();
   }, []);

   return (
      <div>
         <RadioButton
            onUpdate={handleChange}
            options={Object.keys(WALLE_API_URLS).map(k => ({ content: k, value: k }))}
            value={config.apiPreset}
            name={'apiSwitcher'}
         />
      </div>
   );
};
