import React, { Component, PropsWithChildren } from 'react';
import { sentry } from '../services';
import { ErrorBoundaryScreen } from './ErrorBoundaryScreen';

type Props = PropsWithChildren<{}>;

interface IState {
   hasError: boolean;
}

export class ErrorBoundary extends Component<Props, IState> {
   public static getDerivedStateFromError(error: Error): Partial<IState> {
      sentry.sendJsError(error);

      return { hasError: true };
   }

   constructor(props: Props) {
      super(props);
      this.state = { hasError: false };
   }

   public render() {
      if (!this.state.hasError) {
         return this.props.children;
      }

      return <ErrorBoundaryScreen />;
   }
}
