import { FeedbackButton, ModalContainer } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import error400Svg from '../design/icons/400.svg';

import { EXTERNAL_LINKS, ROUTE_LINKS } from '../models';
import { config } from '../services';
import { ErrorScreen } from '../shared';

export const ErrorBoundaryScreen = () => (
   <>
      <ModalContainer />

      <ErrorScreen useButton={false} imgAlt={'JS error'} imgSrc={error400Svg} title={'JavaScript error has happened'}>
         <p>
            The report to{' '}
            <a href={EXTERNAL_LINKS.sentry()} target={'_blank'} rel={'noreferrer noopener'}>
               Sentry
            </a>{' '}
            just already send.
         </p>

         <p>
            Try to <a href={window.location.href}>reload page</a> or return to{' '}
            <a href={ROUTE_LINKS.home()}> start page</a>. If reloading hasn't helped, write to support by clicking this
            icon:
            <FeedbackButton formId={config.feedbackFormId} title={'Wall-E bug report or feedback'} />
         </p>
      </ErrorScreen>
   </>
);

ErrorBoundaryScreen.displayName = 'ErrorBoundaryScreen';
