import { RadioButton } from '@yandex-data-ui/common';
import React from 'react';
import { useCallback } from 'react';

import { config } from '../services';
import { InstallationPreset, WALLE_INSTALLATION_TYPES } from '../services/config';

export const InstallationTypeSwitcher: React.FC = () => {
   const handleChange = useCallback((v: string) => {
      config.installationType = v as InstallationPreset;

      window.location.reload();
   }, []);

   return (
      <div>
         <RadioButton
            onUpdate={handleChange}
            options={Object.keys(WALLE_INSTALLATION_TYPES).map(k => ({ content: k, value: k }))}
            value={config.installationType}
            name={'apiSwitcher'}
         />
      </div>
   );
};
