import * as React from 'react';
import { Link } from 'react-router-dom';

import { ROUTE_LINKS } from '../models';

import logo from './images/logo.svg';
import styles from './MainMenu.module.css';

export const MainMenu = React.memo(() => (
   <div className={styles.mainMenu}>
      <Link to={ROUTE_LINKS.home()}>
         <img className={styles.logo} src={logo} alt={'Wall-E logo'} />
      </Link>
   </div>
));

MainMenu.displayName = 'MainMenu';
