import { useTheme } from '@yandex-data-ui/common';
import { fixedMemo, LegoButton } from '@yandex-infracloud-ui/libs';
import { MoonIcon, SunIcon } from 'design/icons';
import React, { useCallback, useEffect } from 'react';

import { Theme } from '../models';
import { config } from '../services';

export const ThemeSwitcher: React.FC = fixedMemo(() => {
   const [theme, setTheme] = useTheme();

   useEffect(() => {
      config.theme = theme as Theme;
   }, [theme]);

   const handleToggleTheme = useCallback(() => {
      setTheme(theme === Theme.Light ? Theme.Dark : Theme.Light);
   }, [setTheme, theme]);

   return (
      <LegoButton theme={'clear'} onClick={handleToggleTheme}>
         {theme === Theme.Dark ? <SunIcon /> : <MoonIcon />}
      </LegoButton>
   );
});

ThemeSwitcher.displayName = 'ThemeSwitcher';
