import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IAutomationPlot } from '../../models';
import { toastsSupportDecorator } from '../../stories';
import { actionsSupportDecorator } from '../../stories/decorators/actionsSupportDecorator';

import { PlotActionButtons } from './PlotActionButtons';

const item: IAutomationPlot = {
   id: 'test_story',
   name: 'Test Story',
   owners: new Set(['khoden']),
};

storiesOf('actions|automation_plot_actions', module)
   .addDecorator(actionsSupportDecorator)
   .addDecorator(toastsSupportDecorator)
   .add('PlotActionButtons', () => <PlotActionButtons context={item} onActionFinished={action('onActionFinished')} />);
