import { IResult } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { DeleteIcon } from 'design/icons';
import { IAutomationPlot } from '../../models';
import { RowButtons } from '../../shared';
import { PlotAction } from './models';
import { automationPlotActionService } from './plot_action_service';

interface IProps {
   cls?: string;
   context: IAutomationPlot;

   onActionFinished(action: PlotAction, result: IResult[]): void;
}

export const PlotActionButtons = React.memo(({ cls, context, onActionFinished }: IProps) => {
   const buttons = [
      {
         handler: () => {
            automationPlotActionService
               .do(PlotAction.Remove, context)
               .subscribe(
                  resp => onActionFinished(PlotAction.Remove, resp.results),
                  toasts.handleApiError('Remove automation plot'),
               );
         },
         icon: <DeleteIcon />,
         name: 'Remove',
      },
   ];

   return <RowButtons cls={cls} buttons={buttons} />;
});

PlotActionButtons.displayName = 'PlotActionButtons';
