import { boolean, select } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { of } from 'rxjs';

import { HostState, IHost } from '../../models';
import { reduxStoryDecorator } from '../../stories';
import { actionsSupportDecorator } from '../../stories/decorators/actionsSupportDecorator';
import { HostActionButtons } from './HostActionButtons';

const testHosts: Partial<IHost>[] = [
   { name: 'not-exist.yandex.net', inv: 434234, project: 'avatars', status: 'manual' },
];

interface IProps {
   state: HostState;
   status?: string;
   withTask: boolean;
}

function HostActionStory({ withTask, state, status }: IProps) {
   const hosts = testHosts.map(
      host =>
         ({
            ...host,
            state,
            status,
            task: withTask ? { status: 'processing' } : undefined,
         } as IHost),
   );

   return (
      <>
         <HostActionButtons
            compact={boolean('compact', true)}
            currentContext={hosts}
            getSelectedHosts={() => of(hosts)}
            disabled={boolean('disabled', false)}
         />
      </>
   );
}

const states = [HostState.Assigned, HostState.Maintenance, HostState.Free];

const statuses = ['steady', 'task', 'error', 'ready', 'invalid', 'manual'];

function MultiSelectedStory() {
   const context: Partial<IHost>[] = [
      {
         inv: 434234,
         name: 'not-exist.yandex.net',
         project: 'avatars',
         state: HostState.Assigned,
         status: 'manual',
      },
      {
         inv: 434234,
         name: 'not-exist.yandex.net',
         project: 'avatars',
         state: HostState.Maintenance,
         status: 'manual',
         task: { status: 'xx' },
      },
   ];

   return (
      <HostActionButtons
         currentContext={context as IHost[]}
         compact={false}
         getSelectedHosts={() => of(context as IHost[])}
      />
   );
}

storiesOf('actions|host_actions/HostActionButtons', module)
   .addDecorator(actionsSupportDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('variants', () => (
      <>
         <h2>
            Custom (can be edited in knobs, press <kbd>A</kbd>)
         </h2>
         <HostActionStory
            withTask={boolean('withTask', true)}
            state={select('state', states, HostState.Assigned)}
            status={select('status', statuses, 'steady')}
         />

         <h2 style={{ marginTop: '2rem' }}>All variants</h2>
         <table>
            <thead>
               <tr>
                  <th>State/task</th>
                  <th>With task</th>
                  <th>Without task</th>
               </tr>
            </thead>
            <tbody>
               <tr>
                  <th>Assigned</th>
                  <td>
                     <HostActionStory withTask={true} state={HostState.Assigned} />
                  </td>
                  <td>
                     <HostActionStory withTask={false} state={HostState.Assigned} />
                  </td>
               </tr>
               <tr>
                  <th>Maintenance</th>
                  <td>
                     <HostActionStory withTask={true} state={HostState.Maintenance} />
                  </td>
                  <td>
                     <HostActionStory withTask={false} state={HostState.Maintenance} />
                  </td>
               </tr>
               <tr>
                  <th>Free</th>
                  <td>
                     <HostActionStory withTask={true} state={HostState.Free} />
                  </td>
                  <td>
                     <HostActionStory withTask={false} state={HostState.Free} />
                  </td>
               </tr>
            </tbody>
         </table>

         <h2>Invalid host</h2>
         <HostActionStory withTask={true} state={HostState.Assigned} status={'invalid'} />
      </>
   ))
   .add('multi selected', () => <MultiSelectedStory />);
