import React, { ReactNode } from 'react';
import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';

import classes from './CancelTaskHostAction.module.css';
import { ignoreMaintenanceField, reasonField } from './commonFields';
import { WarnIcon } from 'design/icons';

export class CancelTaskHostAction extends HostActionMeta<IHostActionParams> {
   constructor() {
      super({
         action: HostAction.CancelTask,
         fields: [reasonField, ignoreMaintenanceField],
         initialValue: {
            ignore_maintenance: false,
            reason: '',
         },
         name: 'Cancel task',
         titles: ['Cancel task for the host', 'Cancel task for hosts'],
      });
   }

   public getSubtitle(): ReactNode {
      return (
         <div className={classes.warning}>
            <p className={classes.strongWarning}>
               <WarnIcon size={'lg'} className={classes.icon} />
               Cancelling host task is a dangerous operation.
            </p>
            It can leave host in an inconsistent state, with possible eine profile or setup deployment running, VLAN's
            switched to parking, DNS records broken, ITDC tickets opened. You will need to clean it up manually.
         </div>
      );
   }
}
