import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';
import {
   checkField,
   disableAdminRequestsField,
   ignoreMaintenanceField,
   reasonField,
   withAutoHealingField,
} from './commonFields';

interface ICheckDNSHostParams extends IHostActionParams {
   /**
    * Check host after task completion and consider it as failed if host is not healthy
    */
   check: boolean; // true by default

   /**
    * Don't issue any admin requests if something is broken - just fail the task
    */
   disable_admin_requests: boolean; // false by default

   /**
    * Try to automatically repair the host if task will fail
    */
   with_auto_healing: boolean; // false by default (for API), true for UI
}

export class CheckDNSHostAction extends HostActionMeta<ICheckDNSHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.CheckDNS,
         fields: [
            reasonField,

            // Options
            checkField,
            withAutoHealingField,
            disableAdminRequestsField,
            ignoreMaintenanceField,
         ],
         initialValue: {
            check: true,
            disable_admin_requests: false,
            ignore_maintenance: false,
            reason: '',
            with_auto_healing: true,
         },
         name: 'Check DNS',
         titles: ['Check DNS for the host', 'Check DNS for hosts'],
      });
   }
}
