import { FormFieldType } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';

import {
   DefaultDeployConfigPolicy,
   DefaultDeployNetwork,
   DefaultProvisioner,
   IConfigureDeployHostParams,
   IHost,
} from '../../../models';
import { hostApi } from '../../../services';
import { HostAction, HostActionMeta } from '../models';
import {
   deployConfigField,
   deployNetworkField,
   deployTagsField,
   ignoreMaintenanceField,
   reasonField,
   deployConfigPolicyField,
} from './commonFields';

export class DeployConfigHostAction extends HostActionMeta<IConfigureDeployHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.DeployConfig,
         fields: [
            deployConfigField,
            deployConfigPolicyField,
            deployNetworkField,
            deployTagsField,

            reasonField,

            // Options
            ignoreMaintenanceField,

            // hidden
            { name: 'config', type: FormFieldType.Hidden },
            { name: 'provisioner', type: FormFieldType.Hidden, isHidden: p => !p.config },
         ],
         initialValue: {
            config: '',
            deploy_network: DefaultDeployNetwork,
            deploy_config_policy: DefaultDeployConfigPolicy,
            deploy_tags: new Set(),
            ignore_maintenance: false,
            provisioner: DefaultProvisioner,
            reason: '',
         },
         name: 'Configure deploy',
         titles: ['Configuration deploy of the host', 'Configuration deploy of the hosts'],
      });
   }

   public transform(params: IConfigureDeployHostParams): IConfigureDeployHostParams {
      params.config = params._deployConfig ? params._deployConfig.config : '';
      params.provisioner = params._deployConfig ? params._deployConfig.provisioner : DefaultProvisioner;

      return params;
   }

   public do(host: IHost, params: IConfigureDeployHostParams, context: IHost[]): Observable<any> {
      return hostApi.changeDeployConfigAction(host.uuid, this.clean(params, context));
   }
}
